﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace SWAT_Office_App
{
    public partial class Reset_User_Password_Form : Form
    {
        private string selectedUsername;
        public Reset_User_Password_Form(string selectedUser)
        {
            selectedUsername = selectedUser;
            InitializeComponent();
            this.txt_Password1.Focus();
            this.lbl_Prompt2.Visible = false;

            // Monitors the text in each textbox, triggering changes when certain criteria is met
            this.txt_Password1.TextChanged += new EventHandler(this.txt_Box1_TextChanged);
            this.txt_Password2.TextChanged += new EventHandler(this.txt_Box2_TextChanged);
        }
        private void txt_Box1_TextChanged(object sender, EventArgs e)
        {
            if (txt_Password1.Text == Settings_Form.globalAdminPassword)
            {
                this.txt_Password1.Visible = false;
                this.txt_Password2.Visible = true;
                this.lbl_Prompt1.Visible = false;
                this.lbl_Prompt2.Visible = true;
                this.txt_Password2.Focus();
            }
        }
        private void txt_Box2_TextChanged(object sender, EventArgs e)
        {
            TextBox tb = (TextBox)sender;
            if (tb.Text.Length == 0)
                this.btn_Ok.Enabled = false;
            else
                this.btn_Ok.Enabled = true;
        }
        private void btn_Cancel_Click(object sender, EventArgs e)
        {
            this.Close();
        }
        private void btn_Ok_Click(object sender, EventArgs e)
        {
            if (!Manage_User_Accounts.ChangeUserPassword(selectedUsername, txt_Password2.Text))
            {
                Debug.appendText("Error occured while changing password");
                MessageBox.Show("Error occured while changing password", "Error");
            }
            this.Close();
        }
    }
}
